function ShowFWHM(handles)

% This function shows the full width half maximum (FWHM) map of the ZLP for every
% spectrum. It is set after loading the file and updated with the ZLP alignment. It shows the cropped region
% (see Zoom) selected by the user and displays the boundarys of the particle, with the
% threshold selected by the user (see Boundary).

%% Get Handles
Axis     = get(handles.Load,'UserData');
FWHM     = get(handles.ShowFWHM,'UserData');
Zoom     = get(handles.Zoom,'UserData');
Contours = get(handles.Contours,'Value');
Data     = get(handles.CAxisMax,'UserData');

%% Calculate
FWHM         = FWHM(Zoom(2):Zoom(4),Zoom(1):Zoom(3),:);
FWHM(FWHM>5) = NaN;
ScaleY       = Axis(1);
ScaleX       = Axis(2);

%% Create Images

XMax      = ScaleX*size(FWHM,2)/2;
YMax      = ScaleY*size(FWHM,1)/2;
AxisX     = linspace(-XMax,XMax,size(FWHM,2));
AxisY     = linspace(YMax,-YMax,size(FWHM,1));

B=Data{2};
figure;
imagesc(AxisX,AxisY,FWHM);
colormap(hot(255));
colorbar;
xlabel( 'x (nm)' );
ylabel( 'y (nm)' );
title('FWHM Map');
axis equal
set(gca,'FontSize',16);
set(gca,'YDir','normal')

if Contours==1
    hold('on');
    for k = 1:length(B)
        x = B{k}(:,2);
        y = B{k}(:,1);
        plot(x, y, 'b', 'LineWidth', 2);
        xlim([-XMax,XMax]);
        ylim([-YMax,YMax]);
    end
    hold(handles.Axis,'off');
end

clearvars all